unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, AHMSystemClass, AHMTRASManager, ExtCtrls;

type
  TForm1 = class(TForm)
    ahmRasDial: TAHMRASManager;
    lblConnection: TLabel;
    cboConnection: TComboBox;
    edtUserID: TEdit;
    lblUserID: TLabel;
    Label3: TLabel;
    edtPassword: TEdit;
    btnConnect: TButton;
    btnDisconnect: TButton;
    CreaButton: TButton;
    ConfButton: TButton;
    DelButton: TButton;
    Bevel1: TBevel;
    Label1: TLabel;
    lblRasStatus: TListBox;
    Image1: TImage;
    Image2: TImage;
    Label2: TLabel;
    edtNo: TEdit;
    lblDevice: TLabel;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure cboConnectionChange(Sender: TObject);
    procedure edtPasswordChange(Sender: TObject);
    procedure btnConnectClick(Sender: TObject);
    procedure btnDisconnectClick(Sender: TObject);
    procedure ahmRasDialConnected(Sender: TObject);
    procedure ahmRasDialDisConnected(Sender: TObject);
    procedure ahmRasDialConnectFailed(Sender: TObject);
    procedure ahmRasDialMsgOpenPort(Sender: TObject);
    procedure ahmRasDialMsgPortOpened(Sender: TObject);
    procedure ahmRasDialMsgDeviceConnected(Sender: TObject);
    procedure ahmRasDialMsgAuthenicated(Sender: TObject);
    procedure ahmRasDialMsgAllDevicesConnected(Sender: TObject);
    procedure ahmRasDialChangeConnection(Sender: TObject; OldConnection,
      NewConnection: String);
    procedure ahmRasDialMsgAuthAck(Sender: TObject);
    procedure ahmRasDialMsgAuthenticate(Sender: TObject);
    procedure ahmRasDialMsgAuthenticated(Sender: TObject);
    procedure CreaButtonClick(Sender: TObject);
    procedure ConfButtonClick(Sender: TObject);
    procedure DelButtonClick(Sender: TObject);
    procedure UpdateSettings;
    procedure ahmRasDialConnectionExists(Sender: TObject;
      Connection: String);
    procedure edtNoChange(Sender: TObject);
    procedure edtUserIDChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.UpdateSettings;
begin
  edtUserID.Text := '';
  edtPassword.Text := '';
  edtNo.Text:='';
  Label4.Caption:='';
  if (ahmRasDial.Installed) then
  begin
    if (ahmrasdial.connections.count>0) then
    begin
      ahmRasDial.Connection:=cboConnection.Text;
      edtUserID.Text := ahmRasDial.UserName;
      edtNo.Text:=ahmRasDial.Properties.Phonenumber;
      edtPassword.Text := ahmRasDial.Password;
      Label4.Caption:=Uppercase(ahmRasDial.Properties.DeviceType)+' - '+ahmRasDial.Properties.DeviceName;
      cboConnection.Enabled:=True;
      CreaButton.Enabled:=True;
      btnConnect.Enabled:=True;
      btnDisconnect.Enabled:=true;
      ConfButton.Enabled:=True;
      DelButton.Enabled:=True;
    end else
    begin
      cboConnection.Enabled:=False;
      ConfButton.Enabled:=False;
      CreaButton.Enabled:=True;
      DelButton.Enabled:=False;
      btnConnect.Enabled:=False;
      btnDisconnect.Enabled:=False;
    end;
  end else
  begin
    cboConnection.Enabled:=False;
    CreaButton.Enabled:=False;
    DelButton.Enabled:=False;
    ConfButton.Enabled:=False;
    btnConnect.Enabled:=False;
    btnDisconnect.Enabled:=False;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  if ahmrasdial.installed then
  begin
    cboConnection.Items:=ahmRasDial.Connections;
    if ahmRasDial.Connections.Count>0 then cboConnection.ItemIndex:=0;
  end;
  UpdateSettings;
end;

procedure TForm1.cboConnectionChange(Sender: TObject);
begin
  UpdateSettings;
end;

procedure TForm1.edtPasswordChange(Sender: TObject);
begin
  ahmRasDial.Password := edtPassword.Text;
end;

procedure TForm1.btnConnectClick(Sender: TObject);
begin
  ahmRasDial.Connect;
end;

procedure TForm1.btnDisconnectClick(Sender: TObject);
begin
  ahmRasDial.Disconnect;
end;

procedure TForm1.ahmRasDialConnected(Sender: TObject);
begin
  lblRASStatus.Items.Add( 'TForm1.ahmRasDialConnected -- Connected to '+ahmRasDial.Connection);
  lblRasStatus.ItemIndex :=lblRasStatus.Items.Count-1;
  cboConnection.Enabled := False;
  edtNo.Enabled:=False;
  edtUserID.Enabled := False;
  edtPassword.Enabled := False;
  btnConnect.Enabled:=False;
  btnDisconnect.Enabled:=true;
  ConfButton.Enabled:=False;
  DelButton.Enabled:=False;
end;

procedure TForm1.ahmRasDialDisConnected(Sender: TObject);
begin
  Label1.Caption:='';
  lblRASStatus.Items.Add('TForm1.ahmRasDialDisConnected -- Disconnected from '+ahmRasDial.Connection);
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
  cboConnection.Enabled := True;
  edtNo.Enabled:=True;
  edtUserID.Enabled := True;
  edtPassword.Enabled := True;
  btnConnect.Enabled:=True;
  btnDisconnect.Enabled:=False;
  ConfButton.Enabled:=True;
  DelButton.Enabled:=True;
end;

procedure TForm1.ahmRasDialConnectFailed(Sender: TObject);
begin
  ahmRasDialDisConnected(self);
  lblRASStatus.Items.Add('TForm1.ahmRasDialConnectFailed -- Error: '+ahmRasDial.LastError);
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
end;

procedure TForm1.ahmRasDialMsgOpenPort(Sender: TObject);
begin
  lblRASStatus.Items.Add('TForm1.ahmRasDialMsgOpenPort -- Opening Port...');
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
  cboConnection.Enabled := False;
  edtNo.Enabled:=False;
  edtUserID.Enabled := False;
  edtPassword.Enabled := False;
end;

procedure TForm1.ahmRasDialMsgPortOpened(Sender: TObject);
begin
  lblRASStatus.Items.Add('TForm1.ahmRasDialRASError -- Port Openned');
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
  cboConnection.Enabled := False;
  edtNo.Enabled:=False;
  edtUserID.Enabled := False;
  edtPassword.Enabled := False;
end;


procedure TForm1.ahmRasDialMsgDeviceConnected(Sender: TObject);
begin
  lblRASStatus.Items.Add('Connected to '+ahmRasDial.Connection);
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
  cboConnection.Enabled := False;
  edtNo.Enabled:=False;
  edtUserID.Enabled := False;
  edtPassword.Enabled := False;
end;

procedure TForm1.ahmRasDialMsgAuthenicated(Sender: TObject);
begin
  lblRASStatus.Items.Add('Authenticated -- TForm1.ahmRasDialMsgAuthenicated');
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
end;

procedure TForm1.ahmRasDialMsgAllDevicesConnected(Sender: TObject);
begin
  lblRASStatus.Items.Add('TForm1.ahmRasDialMsgAllDevicesConnected -- Device Connected');
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
end;

procedure TForm1.ahmRasDialChangeConnection(Sender: TObject; OldConnection,
  NewConnection: String);
begin
  lblRASStatus.Items.Add('TForm1.ahmRasDialMsgAllDevicesConnected -- Connection Changed:  Old='+OldConnection+'  New ='+NewConnection);
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
end;

procedure TForm1.ahmRasDialMsgAuthAck(Sender: TObject);
begin
  lblRASStatus.Items.Add('TForm1.ahmRasDialMsgAuthAck -- Authentication for '+ahmRasDial.Connection+' acknowleged');
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
end;

procedure TForm1.ahmRasDialMsgAuthenticate(Sender: TObject);
begin
  lblRASStatus.Items.Add('TForm1.ahmRasDialMsgAuthenticate');
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
end;

procedure TForm1.ahmRasDialMsgAuthenticated(Sender: TObject);
begin
  lblRASStatus.Items.Add('TForm1.ahmRasDialMsgAuthenticated: Authenticated');
  lblRasStatus.ItemIndex:=lblRasStatus.Items.Count-1;
end;

procedure TForm1.CreaButtonClick(Sender: TObject);
begin
  {we create an entry on the system phonebook ...
     on NT set it first if you want it in a private phonebook}
  ahmrasdial.CreateEntry;
  cboConnection.Items:=ahmRasDial.Connections;
  cboConnection.ItemIndex:=ahmRasDial.Connections.Count-1;
  UpdateSettings;
end;

procedure TForm1.ConfButtonClick(Sender: TObject);
begin
  if cboConnection.Text<>'' then
  ahmrasDial.ConfigureEntry(cboConnection.Text);
end;

procedure TForm1.DelButtonClick(Sender: TObject);
begin
  {I am not about to test it .. u can :)}
  if cboConnection.Text<>'' then
  if MessageDlg('Are you sure you want to delete this connection item ?',mtwarning,[mbYes,mbNo],0)=mryes then
     ahmrasDial.DeleteEntry(cboConnection.Text);
  cboConnection.Items:=ahmRasDial.Connections;
  if ahmRasDial.Connections.Count>0 then
  cboConnection.ItemIndex:=ahmRasDial.Connections.Count-1;
  UpdateSettings;
end;

procedure TForm1.ahmRasDialConnectionExists(Sender: TObject;
  Connection: String);
begin
  Label1.Caption:='A connection to '+Connection+' is maintained by another Application';
end;

procedure TForm1.edtNoChange(Sender: TObject);
begin
  ahmrasdial.Properties.phonenumber:=edtno.Text;
end;

procedure TForm1.edtUserIDChange(Sender: TObject);
begin
  ahmrasdial.Username:=edtUserID.text;
end;

end.
